/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.2,0.277777)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// inspired from Shane's ribbon variant of https://www.shadertoy.com/view/ls3XWM

void mainImage( out vec4 O, vec2 U )
 {
   float h = iResolution.y;  U = 4.*(U+iMouse.xy)/h;                    // normalized coordinates
   vec2 K = ceil(U); U = 2.*fract(U)-1.;  // or K = 1.+2.*floor(U) to avoid non-fractionals
   float a = atan(U.y,U.x), r=length(U), v=0., A;                       // polar coordinates

   for(int i=0; i<7; i++)
    { // if fractional, there is K.y turns to close the loop via K.x wings.
      v = max (v, ( 1. + .8* cos(A= K.x/K.y*a + iGlobalTime) ) / 1.8  // 1+cos(A) = depth-shading
                   * smoothstep(1., 1.-120./h, 8.*abs(r-.2*sin(A)-.5))), // ribbon (antialiased)
      a += 6.28319;                                                       // next turn
    }

  O = v*vec4(.8,1.0,.3,1.0);
  O.g = sqrt(O.g);                              // greenify
  if ( O.g < 0.0001 ) O.a = 0.0;

 }

void main ( void )
 { mainImage ( gl_FragColor, gl_FragCoord.xy );
 }